from typing import List
from typing import TypeVar; T = TypeVar("T")

def maximum(valeurs: List[T]) -> int:
  """ Renvoie l’indice de la première occurrence de la plus grande valeur d’un tableau.
  @param valeurs le tableau de valeurs (nombres ou textes
  @return l'indice de la plus grande valeur ou -1 si le tableau est vide
  >>> maximum([])
  -1
  >>> maximum([2])
  0
  >>> maximum([2, 3, 1])
  1
  >>> maximum([2, 3, 4, 4])
  2
  >>> maximum([2, 3, 4])
  2
  """
  if 0 == len(valeurs):
    indice = -1
  else:
    indice = 0
    for i in range(1, len(valeurs)):
      if valeurs[i] > valeurs[indice]:
        indice = i
  return indice


def maximum_bis(valeurs: List[T]) -> int:
  """ Renvoie l’indice de la première occurrence de la plus grande valeur d’un tableau.
  @param valeurs le tableau de valeurs (nombres ou textes
  @return l'indice de la plus grande valeur ou -1 si le tableau est vide
  précondition: le tableau est trié par ordre décroissant
  >>> maximum_bis([])
  -1
  >>> maximum_bis([5])
  0
  >>> maximum_bis([5, 2])
  0
  >>> maximum_bis([7, 5, 3])
  0
  >>> maximum_bis([7, 7, 3])
  0

  """
  return -1 if 0 == len(valeurs) else 0


if __name__ == "__main__":
  import doctest; doctest.testmod()
  print(maximum(["aze", "abepi_r"]))
